<?php

namespace MoveOn\MetaField;

use Illuminate\Support\ServiceProvider;

class MoveOnMetaFieldProvider extends ServiceProvider
{
    public function boot()
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/meta_field.php' => config_path('meta_field.php'),
            ], 'mv-metafield-config');

            $this->publishes([
                __DIR__.'/../database/migrations/' => database_path('migrations')
            ], 'mv-metafield-migration');
        }

        $this->loadMigrationsFrom(__DIR__.'/../database/migrations');
    }

    public function register()
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/meta_field.php', 'meta_field');
    }
}
