# ory-frontend-client


## Install

Via Composer

``` bash
$ composer require moveon/ory-frontend-client
```

Once composer has been updated and the package has been installed, the service provider will need to be loaded.

#### Laravel 9.x, 10.x

This package uses auto package discovery. The service provider will automatically be registered.



## Configuration

#### Laravel 9.x, 10.x

open `config/auth.php` and add the following entry to the `guards` array.

           'ory-customer-api' => [
            'driver'        => 'ory.authorizer',
            'provider'      => 'ory-provider',
            'configuration' => 'customer',
        ],
        'ory-admin-api' => [
            'driver'        => 'ory.authorizer',
            'provider'      => 'ory-provider',
            'configuration' => 'admin',
        ],
        'ory-agent-api' => [
            'driver'        => 'ory.authorizer',
            'provider'      => 'ory-provider',
            'configuration' => 'agent',
        ],
        'ory-delivery-api' => [
            'driver'        => 'ory.authorizer',
            'provider'      => 'ory-provider',
            'configuration' => 'delivery',
        ],

And add followring configuration to `providers` array

        'ory-provider' => [
            'driver' => 'ory.provider',
            'repository' => 'ory.repository',
            'model' => App\Models\User::class,
            'auth_identifier_key' => 'auth_identifier'
        ],

Example .env file:
`
ORY_FRONTEND_CUSTOMER_INSTANCE_HOST=https://hardcore-beaver-g29wezyzp3.projects.oryapis.com
ORY_FRONTEND_ADMIN_INSTANCE_HOST=https://hardcore-beaver-g29wezyzp3.projects.oryapis.com
ORY_FRONTEND_AGENT_INSTANCE_HOST=https://hardcore-beaver-g29wezyzp3.projects.oryapis.com
ORY_FRONTEND_DELIVERY_INSTANCE_HOST=https://hardcore-beaver-g29wezyzp3.projects.oryapis.com
`

Usage:

``` php

Route::group(['middleware' => [
    'auth:ory-customer-api',
]], static function (): void {
    Route::get('/', function (Request $request) {
        dd($request->user());
    });
});

Route::group(['middleware' => ['guard:ory-agent-api']], static function (): void {
    Route::get('/agent', function (Request $request) {
        dd($request->user());
    });
});

Route::group(['middleware' => ['guard:ory-admin-api']], static function (): void {
    Route::get('/admin', function (Request $request) {
        dd($request->user());
    });
});


Route::group(['middleware' => ['guard:ory-delivery-api']], static function (): void {
    Route::get('/delivery', function (Request $request) {
        dd($request->user());
    });
});

```