<?php

declare(strict_types=1);

namespace MoveOn\Ory;

use MoveOn\Ory\Users\{StatefulUser, StatelessUser};
use Illuminate\Contracts\Auth\Authenticatable;

/**
 *
 * @internal
 *
 * @api
 */
final class UserRepository extends UserRepositoryAbstract implements UserRepositoryContract
{
    public function fromAccessToken(
        array $session,
        array $config
    ): ?Authenticatable
    {
        $identifier = $session["identity"]["id"];
        $model = $this->createModel($config["model"]);

        $retrievedModel = $model->where(
            $config["auth_identifier_key"], $identifier
        )->first();
        
        if (!$retrievedModel) {
            $retrievedModel = $model->where(
                $config["auth_proxy_identifier_key"], $identifier
            )->first();
        }
        # TODO: not found check
        
        return $retrievedModel;
    }

    /**
     * Create a new instance of the model.
     *
     * @return \Illuminate\Database\Eloquent\Model
     */
    public function createModel($model)
    {
        $class = '\\'.ltrim($model, '\\');

        return new $class;
    }
}
