<?php

declare(strict_types=1);

namespace MoveOn\Ory\Entities;

use Illuminate\Contracts\Auth\Authenticatable;

/**
 * @api
 */
abstract class CredentialEntityAbstract extends EntityAbstract
{
    /**
     * @param null|Authenticatable $user                  The user entity this credential represents.
     * @param null|array           $providerSession               The ID token for this credential.
     */
    public function __construct(
        protected ?Authenticatable $user = null
    ) {
    }

    /**
     * @return array{user: false|string, idToken: null|string, accessToken: null|string, accessTokenDecoded: null|array<mixed>, accessTokenScope: null|array<mixed>, accessTokenExpiration: null|int, accessTokenExpired: null|bool, refreshToken: null|string}
     */
    final public function jsonSerialize(): mixed
    {
        return [
            'user' => json_encode($this->getUser(), JSON_FORCE_OBJECT)
        ];
    }

    abstract public function clear(): self;

    abstract public function setUser(
        ?Authenticatable $user = null,
    ): self;
}
