<?php

declare(strict_types=1);

use MoveOn\Ory\Configuration\Configuration;

return [
    'guards' => [
        'default' => [
            Configuration::CONFIG_TOKEN_CACHE => env("ORY_FRONTEND_TOKEN_CACHE", null),
            Configuration::CONFIG_TOKEN_CACHE_TTL => env("ORY_FRONTEND_TOKEN_CACHE_TTl", 3600),
        ],
        'customer' => [
            Configuration::CONFIG_ORY_HOST => env("ORY_FRONTEND_CUSTOMER_INSTANCE_HOST"),
        ],
        'admin' => [
            Configuration::CONFIG_ORY_HOST => env("ORY_FRONTEND_ADMIN_INSTANCE_HOST"),
        ],
        'agent' => [
            Configuration::CONFIG_ORY_HOST => env("ORY_FRONTEND_AGENT_INSTANCE_HOST"),
        ],
        'delivery' => [
            Configuration::CONFIG_ORY_HOST => env("ORY_FRONTEND_DELIVERY_INSTANCE_HOST"),
        ],
    ],
];
