<?php

declare(strict_types=1);

namespace MoveOn\Ory\Entities;

use Illuminate\Contracts\Auth\Authenticatable;
use JsonSerializable;

/**
 * An entity representing a user credential.
 *
 * @internal
 *
 * @api
 */
final class CredentialEntity extends CredentialEntityAbstract implements CredentialEntityContract, JsonSerializable
{
    public function clear(): self
    {
        $this->user = null;
        return $this;
    }

    public function setUser(
        ?Authenticatable $user = null,
    ): self {
        $this->user = $user;

        return $this;
    }

    public function getUser(): ?Authenticatable {
        return $this->user;
    }



    /**
     * Create a new Credential instance.
     *
     * @param null|Authenticatable $user                  The user entity this credential represents.
     * @param null|string          $session               The ID token for this credential.
     */
    public static function create(
        ?Authenticatable $user = null,
    ): self {
        return new self(
            $user
        );
    }
}
