<?php

declare(strict_types=1);

namespace MoveOn\Ory\Events;

/**
 * @internal
 *
 * @api
 */
abstract class TokenVerificationAttemptingAbstract extends EventAbstract
{
    /**
     * @param string $token Encoded JSON Web Token that will be verification.
     */
    public function __construct(
        public string $token,
        public array $cookie,
    ) {
    }

    /**
     * @psalm-suppress LessSpecificImplementedReturnType
     *
     * @return array{token: string}
     */
    final public function jsonSerialize(): array
    {
        return [
            'token'  => $this->token,
            'cookie' => $this->cookie,
        ];
    }
}
