<?php

declare(strict_types=1);

namespace MoveOn\Ory\Entities;

use Illuminate\Contracts\Auth\Authenticatable;

/**
 * @api
 */
interface CredentialEntityContract extends EntityContract
{
    /**
     * Clear all values from this Credential instance.
     */
    public function clear(): self;
    
    /**
     * Get the user entity this credential represents.
     */
    public function getUser(): ?Authenticatable;
    
    /**
     * Set the user entity this credential represents.
     *
     * @param null|Authenticatable $user The user entity this credential represents.
     */
    public function setUser(
        ?Authenticatable $user = null,
    ): self;
}
