<?php

declare(strict_types=1);

namespace MoveOn\Ory;

use MoveOn\Ory\Auth\Guard;
use MoveOn\Ory\Bridges\{CacheBridge, CacheItemBridge};
use MoveOn\Ory\Guards\{AuthorizationGuard};
use Illuminate\Auth\Access\Response;
use Illuminate\Auth\AuthManager;
use Illuminate\Contracts\Auth\Access\Gate;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Http\Kernel;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use MoveOn\Ory\Middleware\GuardMiddleware;

/**
 * @api
 */
abstract class ServiceProviderAbstract extends ServiceProvider
{
    final public function boot(
        Router $router,
        AuthManager $auth,
        Gate $gate,
    ): self {
        $this->mergeConfigFrom(implode(DIRECTORY_SEPARATOR, [__DIR__, '..', 'config', 'oryFrontend.php']), 'ory');
        $this->publishes([implode(DIRECTORY_SEPARATOR, [__DIR__, '..', 'config', 'oryFrontend.php']) => config_path('oryFrontend.php')], 'ory');
        $auth->extend('ory.authorizer', static fn (Application $app, string $name, array $config): AuthorizationGuard => new AuthorizationGuard($name, $config));
        $auth->provider('ory.provider', static fn (Application $app, array $config): UserProvider => new UserProvider($config));
        $router->aliasMiddleware('guard', GuardMiddleware::class);

        $this->registerMiddleware($router);
        $this->registerRoutes();

        return $this;
    }

    final public function provides()
    {
        return [
            AuthorizationGuard::class,
            CacheBridge::class,
            CacheItemBridge::class,
            Service::class,
            UserProvider::class,
            UserRepository::class,
            GuardMiddleware::class,
        ];
    }

    final public function register(): self
    {
        $this->registerGuards();

        $this->app->singleton(Service::class, static fn (): Service => new Service());
        $this->app->singleton(UserProvider::class, static fn (): UserProvider => new UserProvider());
        $this->app->singleton(UserRepository::class, static fn (): UserRepository => new UserRepository());
        $this->app->singleton(GuardMiddleware::class, static fn (): GuardMiddleware => new GuardMiddleware());
        $this->app->singleton('oryFrontend', static fn (): Service => app(Service::class));
        $this->app->singleton('ory.repository', static fn (): UserRepository => app(UserRepository::class));

        return $this;
    }
    
    /**
     * @codeCoverageIgnore
     */
    final public function registerGuards(): void
    {
    }

    /**
     * @codeCoverageIgnore
     *
     * @param Router $router
     */
    final public function registerMiddleware(
        Router $router,
    ): void {}

    final public function registerRoutes(): void
    {

    }
}
