# ory-frontend-client


## Install

Via Composer

``` bash
$ composer require moveon/ory-frontend-client
```

Once composer has been updated and the package has been installed, the service provider will need to be loaded.

#### Laravel 9.x, 10.x

This package uses auto package discovery. The service provider will automatically be registered.



## Configuration

#### Laravel 9.x, 10.x

open `config/auth.php` and add the following entry to the `guards` array.

```phpt
        'customer-api' => [
            'driver'        => 'ory.authorizer',
            'provider'      => 'ory-provider',
            'configuration' => 'customer',
        ],
        'admin-api' => [
            'driver'        => 'ory.authorizer',
            'provider'      => 'ory-provider',
            'configuration' => 'admin',
        ],
        'agent-api' => [
            'driver'        => 'ory.authorizer',
            'provider'      => 'ory-provider',
            'configuration' => 'agent',
        ],
        'delivery-api' => [
            'driver'        => 'ory.authorizer',
            'provider'      => 'ory-provider',
            'configuration' => 'delivery',
        ]
```           

And add following configuration to `providers` array

        'ory-provider' => [
            'driver' => 'ory.provider',
            'repository' => 'ory.repository',
            'model' => App\Models\User::class,
            'auth_identifier_key' => 'auth_identifier'
        ],

Optional provider config keys:

        // Include if your app stores an alternate ID from Ory
        'auth_proxy_identifier_key' => 'auth_proxy_identifier',

        // Optional: callback invoked when a valid Ory session is present but no local user is found
        // Signature: function(array $session, array $providerConfig, ?string $xSessionToken, array $cookie, ?string $guardName): void
        'on_user_missing' => [App\\Services\\UserService::class, 'handleMissingOryUser'],

Example .env file:
```
ORY_FRONTEND_CUSTOMER_INSTANCE_HOST=https://hardcore-beaver-g29wezyzp3.projects.oryapis.com
ORY_FRONTEND_ADMIN_INSTANCE_HOST=https://hardcore-beaver-g29wezyzp3.projects.oryapis.com
ORY_FRONTEND_AGENT_INSTANCE_HOST=https://hardcore-beaver-g29wezyzp3.projects.oryapis.com
ORY_FRONTEND_DELIVERY_INSTANCE_HOST=https://hardcore-beaver-g29wezyzp3.projects.oryapis.com
```

Usage:

``` php

Route::group(['middleware' => [
    'auth:customer-api',
]], static function (): void {
    Route::get('/', function (Request $request) {
        dd($request->user());
    });
});

Route::group(['middleware' => ['auth:agent-api']], static function (): void {
    Route::get('/agent', function (Request $request) {
        dd($request->user());
    });
});

Route::group(['middleware' => ['auth:admin-api']], static function (): void {
    Route::get('/admin', function (Request $request) {
        dd($request->user());
    });
});


Route::group(['middleware' => ['auth:delivery-api']], static function (): void {
    Route::get('/delivery', function (Request $request) {
        dd($request->user());
    });
});

```
