<?php

declare(strict_types=1);

use MoveOn\Ory\Configuration\Configuration;

return [
    'guards' => [
        'default' => [
            Configuration::CONFIG_TOKEN_CACHE => env("ORY_FRONTEND_TOKEN_CACHE", null),
            Configuration::CONFIG_TOKEN_CACHE_TTL => env("ORY_FRONTEND_TOKEN_CACHE_TTl", 3600),
        ],
        'customer' => [
            Configuration::CONFIG_ORY_MAIN_HOST  => env("ORY_CUSTOMER_MAIN_URL"),
            Configuration::CONFIG_ORY_PROXY_HOST => env("ORY_CUSTOMER_PROXY_URL")
        ],
        'admin' => [
            Configuration::CONFIG_ORY_MAIN_HOST  => env("ORY_ADMIN_MAIN_URL"),
            Configuration::CONFIG_ORY_PROXY_HOST => env("ORY_ADMIN_PROXY_URL")
        ],
        'agent' => [
            Configuration::CONFIG_ORY_MAIN_HOST  => env("ORY_AGENT_MAIN_URL"),
            Configuration::CONFIG_ORY_PROXY_HOST => env("ORY_AGENT_PROXY_URL")
        ],
        'delivery' => [
            Configuration::CONFIG_ORY_MAIN_HOST  => env("ORY_DELIVERY_MAIN_URL"),
            Configuration::CONFIG_ORY_PROXY_HOST => env("ORY_DELIVERY_PROXY_URL")
        ],
    ],
];
