<?php

declare(strict_types=1);

namespace MoveOn\Ory;

use MoveOn\Ory\Events\Configuration\{
    BuildingConfigurationEvent,
    BuiltConfigurationEvent,
};

use MoveOn\Ory\Events\EventContract;

use MoveOn\Ory\Events\Middleware\{
    StatefulMiddlewareRequest,
    StatelessMiddlewareRequest,
};

use MoveOn\Ory\Events\{
    TokenVerificationAttempting,
    TokenVerificationFailed,
    TokenVerificationSucceeded,
};

/**
 * @api
 */
interface EventsContract
{

    /**
     * @var class-string<\MoveOn\Ory\Events\Configuration\BuildingConfigurationEvent>
     */
    public const CONFIGURATION_BUILDING = BuildingConfigurationEvent::class;

    /**
     * @var class-string<\MoveOn\Ory\Events\Configuration\BuiltConfigurationEvent>
     */
    public const CONFIGURATION_BUILT = BuiltConfigurationEvent::class;
    

    /**
     * @var class-string<\MoveOn\Ory\Events\Middleware\StatefulMiddlewareRequest>
     */
    public const MIDDLEWARE_STATEFUL_REQUEST = StatefulMiddlewareRequest::class;

    /**
     * @var class-string<\MoveOn\Ory\Events\Middleware\StatelessMiddlewareRequest>
     */
    public const MIDDLEWARE_STATELESS_REQUEST = StatelessMiddlewareRequest::class;
    

    /**
     * @var class-string<\MoveOn\Ory\Events\TokenVerificationAttempting>
     */
    public const TOKEN_VERIFICATION_ATTEMPTING = TokenVerificationAttempting::class;

    /**
     * @var class-string<\MoveOn\Ory\Events\TokenVerificationFailed>
     */
    public const TOKEN_VERIFICATION_FAILED = TokenVerificationFailed::class;

    /**
     * @var class-string<\MoveOn\Ory\Events\TokenVerificationSucceeded>
     */
    public const TOKEN_VERIFICATION_SUCCEEDED = TokenVerificationSucceeded::class;

    /**
     * Dispatch an SDK event.
     *
     * @param EventContract $event The event to dispatch.
     */
    public static function dispatch(
        EventContract $event,
    ): void;

    /**
     * Dispatch a Laravel framework event.
     *
     * @param object $event The event to dispatch.
     */
    public static function framework(
        object $event,
    ): void;
}
