<?php

declare(strict_types=1);

namespace MoveOn\Ory\Guards;

use MoveOn\Ory\Entities\CredentialEntityContract;

/**
 * @api
 */
interface AuthorizationGuardContract extends GuardContract
{
    /**
     * Searches for an available credential from a specified source in the current request context.
     */
    public function find(): ?CredentialEntityContract;

    /**
     * Get a credential candidate from a provided access token.
     *
     * @return null|CredentialEntityContract Credential object if a valid token is found, null otherwise.
     */
    public function findToken(): ?CredentialEntityContract;
    
    public function setCredential(
        ?CredentialEntityContract $credential = null,
    ): self;
}
