<?php

declare(strict_types=1);

namespace MoveOn\Ory\Entities;

use Ory\Client\Api\FrontendApi;

/**
 * @api
 */
interface InstanceEntityContract extends EntityContract
{
    public function getConfiguration();
    
    public function getSdk(): FrontendApi;


    /**
     * Resets and cleans up the internal state of the SDK.
     */
    public function reset(): self;

    /**
     * @param null|array<string> $configuration
     */
    public function setConfiguration(array | null $configuration): self;

}
