<?php

declare(strict_types=1);

namespace MoveOn\Ory\Entities;

use Ory\Client\Api\FrontendApi;
use function is_array;

/**
 * @api
 */
trait InstanceEntityTrait
{
    public function reset(): self
    {
        unset($this->sdk, $this->configuration);

        $this->sdk = null;
        $this->configuration = null;

        return $this;
    }

    /**
     * @param null|array<string> $configuration
     */
    public function setConfiguration(
        array | null $configuration = null,
    ): self {
        if (is_array($configuration)) {
            $configuration = $this->createConfiguration($configuration);
        }

        $this->configuration = $configuration;

        if ($this->sdk instanceof FrontendApi) {
            $this->sdk->setConfiguration($this->configuration);
        }

        return $this;
    }

    public static function create(
        array | null $configuration = null,
        ?string $guardConfigurationName = null,
    ): self {
        $instance = new self();
        if (null !== $guardConfigurationName) {
            $instance->setGuardConfigurationKey($guardConfigurationName);
        }

        if (null !== $configuration) {
            $instance->setConfiguration($configuration);
        }

        return $instance;
    }
}
