<?php

namespace MoveOn\Subscription\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use MoveOn\Subscription\Enums\FeeType;
use MoveOn\Subscription\Enums\GatewaySlug;
use MoveOn\Subscription\Enums\GatewayType;
use MoveOn\Subscription\Models\PaymentGateway;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<Model>
 */
class PaymentGatewayFactory extends Factory
{
    protected $model = PaymentGateway::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            "name"             => $this->faker->name,
            "slug"             => $this->faker->randomElement(GatewaySlug::values()),
            "gateway_type"     => $this->faker->randomElement(GatewayType::values()),
            "logo"             => $this->faker->url,
            "url"              => $this->faker->url,
            "fee"              => $this->faker->randomFloat(2, 1, 10),
            "fee_type"         => $this->faker->randomElement(FeeType::values()),
            "is_active"        => $this->faker->boolean,
            "customer_visible" => $this->faker->boolean,
        ];
    }
}
