<?php

namespace MoveOn\Subscription\Collection;

use MoveOn\Common\Traits\Makeable;
use MoveOn\Subscription\Contracts\CollectionContract;
use MoveOn\Subscription\Contracts\DTORequestContact;
use MoveOn\Subscription\Traits\ArrayConvertable;

abstract class Collection implements CollectionContract
{
    use Makeable;
    use ArrayConvertable;

    protected array $items = [];

    public function setItem(array $request)
    {
        $this->items[] = $request;
    }
    public function items(): array
    {
        return $this->items;
    }

    public function addToItem($request): static
    {
        $request = $request->toArray();
        $this->setItem($request);
        return $this;
    }

    abstract public function add(DTORequestContact $request): static;
}