<?php

namespace MoveOn\Subscription\Contracts;

use MoveOn\Subscription\Requests\Modules\Stripe\StripeSubscriptionStoreDTORequest;
use MoveOn\Subscription\Response\Gateway\Paypal\PaypalErrorResponse;
use Stripe\Subscription;

interface StripeSubscriptionManagerContract
{
    /**
     * @param string $subscriptionId
     * @return Subscription
     */
    public function getSubscriptionById(string $subscriptionId): Subscription;

    /**
     * @param StripeSubscriptionStoreDTORequest $request
     * @return Subscription
     * @throws PaypalErrorResponse
     */
    public function createSubscription(StripeSubscriptionStoreDTORequest $request): Subscription;

    /**
     * @param string $subscriptionId
     * @return Subscription
     */
    public function cancelSubscription(string $subscriptionId): Subscription;
}