<?php

namespace MoveOn\Subscription\Enums;

use MoveOn\Common\Traits\BaseEnum;

/**
 * @method static STRIPE_INCOMPLETE()
 * @method static STRIPE_INCOMPLETE_EXPIRED()
 * @method static STRIPE_TRAILING()
 * @method static STRIPE_ACTIVE()
 * @method static STRIPE_PAST_DUE()
 * @method static STRIPE_CANCELED()
 * @method static STRIPE_UNPAID()
 */
enum Subscription: string
{
    use BaseEnum;

    case STRIPE_INCOMPLETE = "incomplete";
    case STRIPE_INCOMPLETE_EXPIRED = "incomplete_fixed";
    case STRIPE_TRAILING = "trailing";
    case STRIPE_ACTIVE = "active";
    case STRIPE_PAST_DUE = "past_due";
    case STRIPE_CANCELED = "canceled";
    case STRIPE_UNPAID = "unpaid";

}
