<?php

namespace MoveOn\Subscription\Enums;


use MoveOn\Common\Traits\BaseEnum;

/**
 * @method static STRIPE_INCOMPLETE()
 * @method static STRIPE_INCOMPLETE_EXPIRED()
 * @method static STRIPE_TRIALING()
 * @method static STRIPE_ACTIVE()
 * @method static STRIPE_PAST_DUE()
 * @method static STRIPE_CANCELED()
 * @method static STRIPE_UNPAID()
 *
 * @method static PAYPAL_APPROVAL_PENDING()
 * @method static PAYPAL_APPROVED()
 * @method static PAYPAL_ACTIVE()
 * @method static PAYPAL_SUSPENDED()
 * @method static PAYPAL_CANCELED()
 * @method static PAYPAL_EXPIRED()
 * @method static PAYPAL_PAYMENT_FAILED()
 */
enum SubscriptionStatus: string
{
    use BaseEnum;

    case STRIPE_INCOMPLETE = "incomplete";
    case STRIPE_INCOMPLETE_EXPIRED = "incomplete_expired";
    case STRIPE_TRIALING = "trialing";
    case STRIPE_ACTIVE = "active";
    case STRIPE_PAST_DUE = "past_due";
    case STRIPE_CANCELED = "canceled";
    case STRIPE_UNPAID = "unpaid";

    case PAYPAL_APPROVAL_PENDING = "APPROVAL_PENDING";
    case PAYPAL_APPROVED = "APPROVED";
    case PAYPAL_ACTIVE = "ACTIVE";
    case PAYPAL_SUSPENDED = "SUSPENDED";
    case PAYPAL_CANCELED = "CANCELED";
    case PAYPAL_EXPIRED = "EXPIRED";
    case PAYPAL_PAYMENT_FAILED = "PAYPAL_PAYMENT_FAILED";


}
