<?php

namespace MoveOn\Subscription\Models;

use App\Models\PlanFeature;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use MoveOn\Common\Traits\Filterable;
use Zoha\Metable;

/**
 * @property float $unit_amount
 * @property float $amount
 * @property string $currency
 * @property int $interval_count
 * @property Collection $planTiers
 */
class Plan extends Model
{
    use HasFactory;
    use Metable;
    use SoftDeletes;
    use Filterable;

    protected $guarded = ['id'];
    protected $metaTable;

    protected $casts = [
        "unit_amount"         => "double",
        "system_usage_charge" => "double",
        "is_active"           => "boolean",
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->metaTable = config('subscription.subscription_table_prefix') . '_meta';
        $this->table     = config('subscription.subscription_table_prefix') . '_plans';
    }

    public function planTiers()
    {
        return $this->hasMany(PlanTier::class, "plan_id");
    }

    public function gateway()
    {
        return $this->belongsTo(PaymentGateway::class, "gateway_id");
    }

    public function product()
    {
        return $this->belongsTo(Product::class, "product_id");
    }

    public function subscriptions()
    {
        return $this->hasMany(Subscription::class, "plan_id");
    }

    public function features()
    {
        return $this->hasMany(PlanFeature::class, "plan_id");
    }
}
