<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Zoha\Metable;

class PlanTier extends Model
{
    use HasFactory;
    use Metable;
    use SoftDeletes;

    protected $guarded = ['id'];
    protected $metaTable;

    protected $casts = [
        "unit_amount" => "double"
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->metaTable = config('subscription.subscription_table_prefix') . '_meta';
        $this->table = config('subscription.subscription_table_prefix') . '_plan_tiers';
    }
}
