<?php

namespace MoveOn\Subscription\Modules\Gateway;

use Illuminate\Support\Arr;
use MoveOn\Subscription\Contracts\GatewayManagerStripeSessionContract;
use MoveOn\Subscription\Contracts\GatewayManagerStripeSubscriptionItemContract;
use MoveOn\Subscription\Contracts\StripeSubscriptionManagerContract;
use MoveOn\Subscription\Requests\Modules\Stripe\StripeSubscriptionStoreDTORequest;
use MoveOn\Subscription\Response\Gateway\Stripe\StripeErrorResponse;
use Stripe\Exception\ApiErrorException as ApiErrorExceptionAlias;
use Stripe\StripeClient;
use Stripe\Subscription;
use Stripe\UsageRecord;

class StripeSessionManager implements GatewayManagerStripeSessionContract
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    public function createSubscriptionSession(string $priceId, string $successURL, string $cancelURL,)
    {
        return $this->stripe->checkout->sessions->create(
            [
                'success_url' => $successURL,
                'cancel_url'  => $cancelURL,

                'line_items' => [
                    [
                        'price'    => $priceId,
//                        'quantity'    => 1,
                    ],
                ],

                'mode' => 'subscription',
            ]
        );
    }
}