<?php

namespace MoveOn\Subscription\Modules\Gateway;

use Illuminate\Support\Arr;
use MoveOn\Subscription\Contracts\StripeSubscriptionManagerContract;
use MoveOn\Subscription\Requests\Modules\Stripe\StripeSubscriptionStoreDTORequest;
use MoveOn\Subscription\Response\Gateway\Stripe\StripeErrorResponse;
use Stripe\Exception\ApiErrorException as ApiErrorExceptionAlias;
use Stripe\StripeClient;
use Stripe\Subscription;

class StripeSubscriptionManager implements StripeSubscriptionManagerContract
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    public function getSubscriptionById(string $subscriptionId): Subscription
    {
        return $this->stripe->subscriptions->retrieve(
            $subscriptionId,
            ["expand" => ['latest_invoice.payment_intent'],]
        );
    }

    /**
     * @throws ApiErrorExceptionAlias|StripeErrorResponse
     */
    public function createSubscription(StripeSubscriptionStoreDTORequest $form): Subscription
    {
        try {
            $form = Arr::whereNotNull($form->pureArray(true));
//            dd($form);
            return $this->stripe->subscriptions->create($form);
        }catch (\Exception $exception){
            throw new StripeErrorResponse(get_class($this) . ":createSubscription:" , $exception, 500);
        }
    }

    /**
     * @throws ApiErrorExceptionAlias
     */
    public function cancelSubscription(string $subscriptionId): Subscription
    {
        return $this->stripe->subscriptions->cancel($subscriptionId);
    }
}