<?php

namespace MoveOn\Subscription\Modules\Webhook\Stripe;

use Illuminate\Support\Facades\Log;
use MoveOn\Subscription\Contracts\WebhookProcessorContract;
use Stripe\Event;
use Stripe\Exception\SignatureVerificationException;
use Stripe\Stripe;
use Stripe\Webhook;

class StripeWebhook implements WebhookProcessorContract
{
    public function __construct(protected string $secret){
        if(empty($this->secret)) throw new \Exception("Give valid stripe secret");
    }

    protected function getEvents(): array
    {
        return config("subscription.stripe.events.webhook") ?? [];
    }

    public function process(): void
    {
        Stripe::setApiKey($this->secret);

        $payload    = file_get_contents('php://input');
        $sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
        $endpointSecret = config("subscription.stripe.webhook_ids.". request()->route()->getName());

        $event  = Webhook::constructEvent(
            $payload, $sig_header, $endpointSecret
        );

        $this->dispatchEvent($event);

        http_response_code(200);
    }

    private function dispatchEvent(Event $payload)
    {
        $events = $this->getEvents();

        $eventName = $payload->type;

        if (!array_key_exists($eventName, $events)) throw new \Exception(get_class($this) . " Unknown Event given:".json_encode($payload), 500);

        if (!empty($events[$eventName])) event(new $events[$eventName]($payload->toArray()));
    }

}