<?php

namespace MoveOn\Subscription\QueryFilters;

use MoveOn\Common\Modules\QueryFilter;
use MoveOn\Subscription\Enums\FeeType;
use MoveOn\Subscription\Enums\GatewayType;

class PaymentGatewayFilter extends QueryFilter
{

    public static function filterableDetails(): array
    {
        return array_merge( [
            "id" => [
                "type" => "integer",
            ],

            "name" => [
                "type" => "string",
            ],

            "slug" => [
                "type" => "string",
            ],

            "gateway_type" => [
                "type"   => "select",
                "values" => GatewayType::pairedValues(),
            ],

            "fee_type" => [
                "type"   => "select",
                "values" => FeeType::pairedValues(),
            ],
            "fee"      => [
                "type" => "price_range",
            ]
        ], parent::filterableDetails());
    }


    protected function id($query, $param)
    {
        return $query->where("id", "$param");
    }

    protected function name($query, $param)
    {
        return $query->where("name", "like", "%$param%");
    }

    protected function slug($query, $param)
    {
        return $query->where("slug", "$param");
    }

    protected function gatewayType($query, $param)
    {
        return $query->where("gateway_type", "$param");
    }

    protected function fee($query, $param)
    {
        if(is_array($param) && count($param) == 2){
            return $query->whereBetween("fee", $param);
        }

        return $query;
    }

    protected function feeType($query, $param)
    {
        return $query->where("fee_type", "$param");
    }

    protected function isActive($query, $param)
    {
        return $query->where("is_active", "$param");
    }

    protected function customerVisible($query, $param)
    {
        return $query->where("customer_visible", "$param");
    }

}