<?php

namespace MoveOn\Subscription\QueryFilters;

use MoveOn\Common\Modules\QueryFilter;
use MoveOn\Subscription\Enums\IntervalUnit;
use MoveOn\Subscription\Enums\PricingScheme;
use MoveOn\Subscription\Enums\QuantitySource;
use MoveOn\Subscription\Enums\UsageType;

class ProductFilter extends QueryFilter
{

    public static function filterableDetails(): array
    {
        return array_merge( [
            "id" => [
                "type" => "integer",
            ],

            "name" => [
                "type" => "string",
            ],

            "gateway_product_id" => [
                "type" => "string",
            ],

            "gateway_id" => [
                "type" => "integer",
            ],

            "category" => [
                "type" => "string",
            ]
        ], parent::filterableDetails());
    }


    protected function name($query, $param)
    {
        return $query->where("name", "like", "%$param%");
    }

    protected function gatewayId($query, $param)
    {
        return $query->where("gateway_id", $param);
    }

    protected function gatewayProductId($query, $param)
    {
        return $query->where("gateway_product_id", $param);
    }

    protected function category($query, $param)
    {
        return $query->where("category", $param);
    }
}