<?php

namespace MoveOn\Subscription\Contracts;

use MoveOn\Subscription\Modules\Gateway\ClientStripe;
use MoveOn\Subscription\Modules\Gateway\StripePlanManager;
use MoveOn\Subscription\Modules\Gateway\StripeProductManager;
use MoveOn\Subscription\Modules\Gateway\StripeSubscriptionManager;
use MoveOn\Subscription\Modules\Gateway\StripSetupIntentManagerStripe;

#[ClientStripe("stripe_secret")]
interface GatewayClientStripe
{
    public function customer(): GatewayManagerStripeCustomerContract;

    public function product(): StripeProductManager;

    public function plan(): StripePlanManager;

    public function subscription(): StripeSubscriptionManager;

    public function subscriptionItem(): GatewayManagerStripeSubscriptionItemContract;

    public function session(): GatewayManagerStripeSessionContract;

    public function invoice(): GatewayManagerStripeInvoiceContract;

    public function setupIntent() : StripSetupIntentManagerStripe;

    public function paymentMethod() : GatewayManagerStripePaymentMethodContract;
}