<?php

namespace MoveOn\Subscription\Enums\Gateway\Stripe;

use MoveOn\Common\Traits\BaseEnum;

enum StripeSubscriptionPaymentMethodType: string
{
    use BaseEnum;

    case ACH_DEBIT        = "ach_debit";
    case ACSS_DEBIT       = "acss_debit";
    case AU_BECS_DEBIT    = "au_becs_debit";
    case BACS_DEBIT       = "bacs_debit";
    case BANCONTACT       = "bancontact";
    case BOLETO           = "boleto";
    case CARD             = "card";
    case CUSTOMER_BALANCE = "customer_balance";
    case EPS              = "eps";
    case FPX              = "fpx";
    case GIROPAY          = "giropay";
    case GRABPAY          = "grabpay";
    case IDEAL            = "ideal";
    case KONBINI          = "konbini";
    case LINK             = "link";
    case P24              = "p24";
    case PAYNOW           = "paynow";
    case PROMPTPAY        = "promptpay";
    case SOFORT           = "sofort";
    case SEPA_DEBIT       = "sepa_debit";
    case US_BANK_ACCOUNT  = "us_bank_account";
    case WECHAT_PAY       = "wechat_pay";

}