<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use MoveOn\Common\Traits\Filterable;
use MoveOn\Subscription\Enums\DiscountDuration;
use MoveOn\Subscription\Enums\FeeType;
use Zoha\Metable;

/**
 * @property FeeType $amount_type
 * @property float $amount
 * @property float $maximum_discount_amount
 */
class Discount extends Model
{
    use HasFactory;
    use Metable;
    use SoftDeletes;
    use Filterable;

    protected $metaTable;
    protected $table;

    protected $guarded = ['id'];

    protected $casts = [
        "amount_type"             => FeeType::class,
        "duration"                => DiscountDuration::class,
        "amount"                  => "double",
        "maximum_discount_amount" => "double",
        "is_active"               => "boolean",
        "expired_at"              => "datetime",
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->metaTable = config('subscription.subscription_table_prefix') . '_meta';
        $this->table     = config('subscription.subscription_table_prefix') . '_discounts';
    }

    public function discountUsers()
    {
        return $this->hasMany(DiscountUser::class);
    }

    public function getMetaTable()
    {
        return $this->metaTable;
    }

    public function gateway()
    {
        return $this->belongsTo(PaymentGateway::class, "gateway_id");
    }
}