<?php

namespace MoveOn\Subscription\Modules\Gateway;

use MoveOn\Subscription\Contracts\GatewayManagerStripeSetupIntentsContract;
use Stripe\Exception\ApiErrorException;
use Stripe\SetupIntent;
use Stripe\StripeClient;

class StripSetupIntentManagerStripe implements GatewayManagerStripeSetupIntentsContract
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    /**
     * @throws ApiErrorException
     */
    public function createSetupIntent(array $form): SetupIntent
    {
        return $this->stripe->setupIntents->create($form);
    }

}