<?php

namespace MoveOn\Subscription\Modules\Gateway;

use MoveOn\Subscription\Contracts\GatewayManagerStripeCustomerContract;
use Stripe\Collection;
use Stripe\Customer;
use Stripe\Exception\ApiErrorException;
use Stripe\PaymentMethod;
use Stripe\StripeClient;

class StripeCustomerManager implements GatewayManagerStripeCustomerContract
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    /**
     * @throws ApiErrorException
     */
    public function allPaymentMethods(array $params = []): Collection
    {
        return $this->stripe->customers->allPaymentMethods($params["customer_id"], [
            'type' => 'card',
        ]);
    }

    /**
     * @throws ApiErrorException
     */
    public function retrieveCustomer(array $params = []): Customer
    {
        return $this->stripe->customers->retrieve($params["customer_id"]);
    }

    public function createCustomer(array $params = [])
    {
        return $this->stripe->customers->create($params);
    }

    /**
     * @throws ApiErrorException
     */
    public function setDefaultPaymentMethod(array $params = []): Customer
    {
        return $this->stripe->customers->update($params["customer_id"], [
            "invoice_settings" => [
                "default_payment_method" => $params["payment_method_id"]
            ]
        ]);
    }

    /**
     * @throws ApiErrorException
     */
    public function attachPaymentMethod(array $form): PaymentMethod
    {
        return $this->stripe->paymentMethods->attach($form['payment_method'], [
            'customer' => $form['customer'],
        ]);
    }

}