<?php

namespace MoveOn\Subscription\Modules\Gateway;

use Illuminate\Support\Arr;
use MoveOn\Subscription\Contracts\GatewayManagerStripeSubscriptionItemContract;
use MoveOn\Subscription\Contracts\StripeSubscriptionManagerContract;
use MoveOn\Subscription\Requests\Modules\Stripe\StripeSubscriptionStoreDTORequest;
use MoveOn\Subscription\Response\Gateway\Stripe\StripeErrorResponse;
use Stripe\Exception\ApiErrorException as ApiErrorExceptionAlias;
use Stripe\StripeClient;
use Stripe\Subscription;
use Stripe\UsageRecord;

class StripeSubscriptionItemManager implements GatewayManagerStripeSubscriptionItemContract
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    public function createUsageRecord(string $itemId, int $quantity, int $timestamp): UsageRecord
    {
        $this->stripe->subscriptionItems->createUsageRecord(
            $itemId,
            [
                "quantity" => $quantity,
                "action" => "set",
                "timestamp" => $timestamp
            ]
        );
    }
}