<?php

namespace MoveOn\Subscription\Requests;

use Exception;
use MoveOn\Subscription\Enums\DiscountDuration;
use MoveOn\Subscription\Enums\FeeType;

class DiscountStoreRequest extends BaseRequest
{
    public function __construct(
        public string $name,
        public string $coupon_code,
        public DiscountDuration $duration,
        public FeeType $amount_type,
        public float $amount,
        public int $duration_in_months,
        public ?float $maximum_discount_amount = null,
        public ?string $currency = "USD",
        public bool $is_active = false,
        public ?string $expired_at = null,
    ) {
        if ($this->amount_type == FeeType::PERCENTAGE && $this->amount > 100) {
            throw new Exception(
                "Subscription:DiscountRequest:When amount type percent, amount can not be greater than 100",
                422
            );
        }
    }
}