<?php

namespace MoveOn\Subscription\Requests\Modules\Paypal\Plan;

use MoveOn\Subscription\Requests\BaseRequest;
use MoveOn\Subscription\Requests\Modules\Paypal\PaypalMoney;

class PaypalPlanTier extends BaseRequest
{
    public function __construct(
        public ?int $starting_quantity = null,
        public ?int $ending_quantity = null,
        public ?PaypalMoney $amount = null,
    ) {
    }

    protected function paramDbMap(): array
    {
        return [
            "starting_quantity" => "start",
            "ending_quantity" => "end",
            "amount" => "unit_amount",
        ];
    }
}