<?php

namespace MoveOn\Subscription\Traits;

use Illuminate\Support\Arr;
use MoveOn\Subscription\Contracts\CollectionContract;
use MoveOn\Subscription\Contracts\DTORequestContact;
use UnitEnum;

trait ArrayConvertable
{
    public function pureArray(bool $removeNulls = false):array
    {
        if(is_subclass_of(static::class, DTORequestContact::class)) return $this->childToPureArray($this->toArray(), $removeNulls);
        if(is_subclass_of(static::class, CollectionContract::class)) return $this->childToPureArray($this->items(), $removeNulls);

        throw new \Exception("This object is not convertable to pure array");
    }

    private function childToPureArray(DTORequestContact|CollectionContract|array $items, bool $removeNulls = false): array
    {
        if($items instanceof \MoveOn\Subscription\Contracts\DTORequestContact) $items = $items->toArray();
        if($items instanceof \MoveOn\Subscription\Contracts\CollectionContract) $items = $items->items();

        foreach ($items as $key => $value){
            if(is_array($value)){
                $items[$key] = $this->childToPureArray($value, $removeNulls);
                if($removeNulls) $items[$key] = Arr::whereNotNull($items[$key]);
                continue;
            }

            if($value instanceof \MoveOn\Subscription\Contracts\CollectionContract)
            {
                $items[$key] = $this->childToPureArray($value, $removeNulls);
                if($removeNulls) $items[$key] = Arr::whereNotNull($items[$key]);
                continue;
            }

            if($value instanceof \MoveOn\Subscription\Contracts\DTORequestContact)
            {
                $items[$key] = $this->childToPureArray($value, $removeNulls);
                if($removeNulls) $items[$key] = Arr::whereNotNull($items[$key]);
                continue;
            }

            if($value instanceof UnitEnum)
            {
                $items[$key] = $value->value;
            }
        }

        return $items;
    }
}