<?php

namespace Tests\Unit;

use MoveOn\Subscription\Contracts\GatewayClientStripe;
use MoveOn\Subscription\Modules\Gateway\StripSetupIntentManagerStripe;
use PHPUnit\Framework\TestCase;
use Stripe\Exception\ApiErrorException;
use Stripe\SetupIntent;
use Stripe\StripeClient;
use Mockery;

class StripSetupIntentManagerTest extends TestCase
{


    /**
     * @throws ApiErrorException
     */
    public function test_create_setup_intent()
    {
        // Mock StripeClient and SetupIntent
        $mockStripeClient = Mockery::mock(StripeClient::class);
        $mockSetupIntent = Mockery::mock(SetupIntent::class);

        $mockSetupIntents = Mockery::mock();
        $mockSetupIntents->shouldReceive('create')
            ->with([
                'customer' => 'cus_test123',
                'payment_method_types' => ['card'],
            ])
            ->once()
            ->andReturn($mockSetupIntent);

        $mockStripeClient->setupIntents = $mockSetupIntents;

        // Initialize the manager with the mocked client
        $manager = new StripSetupIntentManagerStripe($mockStripeClient);

        // Call the method
        $result = $manager->createSetupIntent([
            'customer' => 'cus_test123',
            'payment_method_types' => ['card'],
        ]);

        // Assert the response is the mocked SetupIntent
        $this->assertSame($mockSetupIntent, $result);
    }
}
