<?php

namespace MoveOn\Subscription\Contracts;

use Illuminate\Http\Request;
use MoveOn\Subscription\Models\Discount;
use MoveOn\Subscription\Models\DiscountUsageHistory;
use MoveOn\Subscription\Models\DiscountUser;
use MoveOn\Subscription\Requests\DiscountStoreRequest;
use MoveOn\Subscription\Requests\DiscountUpdateRequest;

interface ServiceContractDiscount
{
    public function listDiscount(Request $request): array;

    public function createDiscount(DiscountStoreRequest $request, int $gatewayId): Discount;

    public function updateDiscount(Discount $discount, DiscountUpdateRequest $request): Discount;

    public function activateDiscount(Discount $discount): bool;

    public function deactivateDiscount(Discount $discount): bool;

    public function deleteDiscount(Discount $discount): bool;

    public function listDiscountUser(Request $request): array;

    public function createDiscountUser(
        Discount $discount,
        ?string $owner_type = null,
        ?int $owner_id = null,
        ?int $gateway_id = null,
        ?int $plan_id = null
    ): DiscountUser;

    public function checkDiscountUser(
        Discount $discount,
        ?string $ownerType,
        ?int $ownerId,
        ?int $gatewayId,
        int $planId
    ): bool;

    public function deleteDiscountUser(DiscountUser $discountUser): bool;

    public function activateDiscountUser(DiscountUser $discountUser): bool;

    public function deactivateDiscountUser(DiscountUser $discountUser): bool;

    public function listDiscountUsageHistory(Request $request): array;

    public function createDiscountUsageHistory(
        Discount $discount,
        string $owner_type,
        int $owner_id,
        int $subscription_id,
    ): DiscountUsageHistory;

    public function updateDiscountUsageHistory(
        DiscountUsageHistory $history,
        Discount $discount,
        string $owner_type,
        int $owner_id,
        int $subscription_id,
    ): bool;
}