<?php

namespace MoveOn\Subscription\Enums;

use MoveOn\Common\Traits\BaseEnum;

/**
 * @method static DAY()
 * @method static WEEK()
 * @method static MONTH()
 * @method static YEAR()
 *
 * @method static PAYPAL_DAY()
 * @method static PAYPAL_WEEK()
 * @method static PAYPAL_MONTH()
 * @method static PAYPAL_YEAR()
 */
enum IntervalUnit: string
{
    use BaseEnum;

    case DAY = "day";
    case WEEK = "week";
    case MONTH = "month";
    case YEAR = "year";

    case PAYPAL_DAY = "DAY";
    case PAYPAL_WEEK = "WEEK";
    case PAYPAL_MONTH = "MONTH";
    case PAYPAL_YEAR = "YEAR";
}
