<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use MoveOn\Common\Traits\Filterable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Zoha\Metable;

class SubscriptionItem extends Model
{
    use HasFactory;
    use Filterable;
    use Metable;

    protected $metaTable;
    protected $table;

    protected $guarded = ['id'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->metaTable = config('subscription.subscription_table_prefix') . '_meta';
        $this->table = config('subscription.subscription_table_prefix') . '_subscription_items';
    }

    public function subscription()
    {
        return $this->belongsTo(Subscription::class, "subscription_id");
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class, "plan_id");
    }
}
