<?php

namespace MoveOn\Subscription\Modules\Gateway;

use Stripe\StripeClient;

class StripeProductManager
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    public function createProduct($form)
    {
        return $this->stripe->products->create($form);
    }

    public function updateProduct(string $productId, array $payload)
    {
        return $this->stripe->products->update(
            $productId,
            $payload
        );
    }
}