<?php

namespace MoveOn\Subscription\QueryFilters;

use MoveOn\Common\Modules\QueryFilter;
use MoveOn\Subscription\Enums\Subscription as SubscriptionEnum;

class SubscriptionFilter extends QueryFilter
{

    public static function filterableDetails(): array
    {
        return array_merge( [
            "id" => [
                "type" => "integer",
            ],

            "plan_id" => [
                "type" => "integer",
            ],

            "gateway_id" => [
                "type" => "integer",
            ],

            "discount_id" => [
                "type" => "integer",
            ],

            "gateway_subscription_id" => [
                "type" => "string",
            ],

            "status" => [
                "type"   => "select",
                "values" => SubscriptionEnum::pairedValues(),
            ]
        ], parent::filterableDetails());
    }

    protected function planId($query, $param)
    {
        return $query->where("plan_id", $param);
    }

    protected function gatewayId($query, $param)
    {
        return $query->where("gateway_id", $param);
    }

    protected function discountId($query, $param)
    {
        return $query->where("discount_id", $param);
    }

    protected function gatewaySubscriptionId($query, $param)
    {
        return $query->where("gateway_subscription_id", "LIKE", "%$param%");
    }

    protected function status($query, $param)
    {
        return $query->where("status", $param);
    }


}