<?php

namespace MoveOn\Subscription\Requests\Modules\Stripe;

use MoveOn\Subscription\Collection\Modules\Stripe\StripeSubscriptionPaymentMethodSettingCollection;
use MoveOn\Subscription\Collection\Modules\Stripe\StripeSubscriptionStoreItemCollection;
use MoveOn\Subscription\Enums\Gateway\Stripe\StripeSubscriptionPaymentBehaviourEnum;
use MoveOn\Subscription\Requests\BaseRequest;

class StripeSubscriptionStoreDTORequest extends BaseRequest
{
    public function __construct(
        public string $customer,
        public StripeSubscriptionStoreItemCollection $items,
        public StripeSubscriptionPaymentBehaviourEnum $payment_behavior,
        public string $trial_period_days,
        public bool $cancel_at_period_end,
        public ?int $quantity = null,
        public ?StripeSubscriptionPaymentMethodSetting $payment_settings = null,
        public ?string $description = null,
        public ?string $coupon = null,
        public array $expand = []
    ){}
}