<?php

namespace MoveOn\Subscription\Requests;

use MoveOn\Subscription\Enums\GatewaySlug;
use MoveOn\Subscription\Models\GatewayAssociatedCustomer;
use MoveOn\Subscription\Models\Discount;
use MoveOn\Subscription\Models\PaymentGateway;
use MoveOn\Subscription\Models\Plan;

class SubscriptionCreateDTORequest extends BaseRequest
{
    public function __construct(
        public int $owner_id,
        public string $owner_type,
        public PaymentGateway $gateway,
        public Plan $plan,
        public int $quantity = 1,
        public ?Discount $discount = null,
        public ?GatewayAssociatedCustomer $customer = null,
        public bool $cancel_at_period_end = false
    ) {
        if ($this->gateway->slug == GatewaySlug::STRIPE() && empty($this->customer)) {
            throw new \Exception("SubscriptionCreateDTORequest:__construct:customer can not be empty when gateway:{$this->gateway->slug}", 422);
        }

        if ($this->gateway->slug == GatewaySlug::PAYPAL() && empty($this->customer)) {
            throw new \Exception("SubscriptionCreateDTORequest:__construct:customer can not be empty when gateway:{$this->gateway->slug}", 422);
        }
    }
}