<?php

namespace MoveOn\Subscription\Tests;

use Closure;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Schema\SQLiteBuilder;
use Illuminate\Database\SQLiteConnection;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Support\Fluent;
use MoveOn\Subscription\Database\Seeders\PaymentGatewaySeeder;
use MoveOn\Subscription\Models\Discount;
use MoveOn\Subscription\MoveOnSubscriptionProvider;
use \Orchestra\Testbench\TestCase as OrchestraTestBench;
use Zoha\Meta\MetaServiceProvider;

abstract class TestCase extends OrchestraTestBench
{
    use DatabaseMigrations;

    public function __construct(?string $name = null, array $data = [], string $dataName = '')
    {
        parent::__construct($name, $data, $dataName);
        $this->hotfixSqlite();
    }
    /**
     *
     */
    public function hotfixSqlite()
    {
        \Illuminate\Database\Connection::resolverFor('sqlite', function ($connection, $database, $prefix, $config) {
            return new class($connection, $database, $prefix, $config) extends SQLiteConnection {
                public function getSchemaBuilder()
                {
                    if ($this->schemaGrammar === null) {
                        $this->useDefaultSchemaGrammar();
                    }
                    return new class($this) extends SQLiteBuilder {
                        protected function createBlueprint($table, Closure $callback = null)
                        {
                            return new class($table, $callback) extends Blueprint {
                                public function dropForeign($index)
                                {
                                    return new Fluent();
                                }
                            };
                        }
                    };
                }
            };
        });
    }


    /**
     * Set up
     */
    protected function setUp(): void
    {
        parent::setUp();
        $this->artisan("db:seed", ["--class" => PaymentGatewaySeeder::class]);
    }

    /**
     * Define environment setup.
     *
     * @param Application $app
     * @return void
     */
    protected function getEnvironmentSetUp($app)
    {
        $app["config"]->set("subscription.subscription_table_prefix", "subscription");

        $app["config"]->set("subscription.paypal.client_id", "AWXhp2ukuyIhqsB23Vt2_KsSM_q-_AExBq2KuNdN3VptqcfBVIUVcN0QMPdeXNJOnmOQeWk0sPge00dJ");
        $app["config"]->set("subscription.paypal.client_secret", "EOUy9CvEuNJOkBGGme63Rv53AQw0RUg8CYlMOQ0nKCWjOOc7kBieSxXAedMjbdFf4uZjaajufx-0tRZh");
        $app["config"]->set("subscription.paypal.base_url", "https://api-m.sandbox.paypal.com/v1");

        $app["config"]->set("subscription.stripe.client_id", "pk_test_TYooMQauvdEDq54NiTphI7jx");
        $app["config"]->set("subscription.stripe.client_secret", "sk_test_4eC39HqLyjWDarjtT1zdp7dc");

        $app["config"]->set("meta.tables.default", "meta");
        $app["config"]->set(
            "meta.tables.custom",
            [
                (new Discount())->getMetaTable(),
            ]
        );
    }

    /**
     * @param Application $app
     * @return array
     */
    protected function getPackageProviders($app)
    {
        return [
            MoveOnSubscriptionProvider::class,
            MetaServiceProvider::class,
        ];
    }
}
