<?php

namespace MoveOn\Subscription\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use MoveOn\Subscription\Enums\IntervalUnit;
use MoveOn\Subscription\Enums\PricingScheme;
use MoveOn\Subscription\Enums\QuantitySource;
use MoveOn\Subscription\Enums\UsageType;
use MoveOn\Subscription\Models\PaymentGateway;
use MoveOn\Subscription\Models\Plan;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\MoveOn\Subscription\Models\Plan>
 */
class PlanFactory extends Factory
{
    protected $model = Plan::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            "currency"            => "USD",
            "name"                => $this->faker->text(5),
            "description"         => $this->faker->text(20),
            "unit_amount"         => $this->faker->randomFloat(100),
            "quantity_source"     => $this->faker->randomElement(QuantitySource::values()),
            "default_quantity"    => 0,
            "usage_type"          => $this->faker->randomElement(UsageType::values()),
            "interval_unit"       => $this->faker->randomElement(IntervalUnit::values()),
            "interval_count"      => rand(1, 7),
            "pricing_scheme"      => $this->faker->randomElement(PricingScheme::values()),
            "trial_period_days"   => rand(1, 30),
            "system_usage_charge" => $this->faker->randomFloat(100),
            "is_active"           => $this->faker->boolean,
            "gateway_plan_id"           => mt_rand(11111, 99999),
        ];
    }
}
