<?php

namespace MoveOn\Subscription\Contracts;

use MoveOn\Subscription\Requests\Modules\Paypal\Plan\PaypalPlanStore;
use MoveOn\Subscription\Response\Gateway\Paypal\PaypalErrorResponse;
use MoveOn\Subscription\Response\Gateway\Paypal\PaypalPlanResponse;
use MoveOn\Subscription\Response\Gateway\Paypal\Product\PaypalProductResponse;

interface PaypalPlanManagerContract
{
    /**
     * @param PaypalPlanStore $request
     * @return PaypalPlanResponse
     * @throws PaypalErrorResponse
     */
    public function createPlan(PaypalPlanStore $request): PaypalPlanResponse;

    /**
     * @param string $planId
     * @return bool
     */
    public function activatePlan(string $planId): bool;

    /**
     * @param string $planId
     * @return bool
     */
    public function deactivatePlan(string $planId): bool;

    /**
     * @param string $planId
     * @return PaypalPlanResponse
     */
    public function detailsPlan(string $planId): PaypalPlanResponse;
}