<?php

namespace MoveOn\Subscription\Contracts;

use Illuminate\Http\Request;
use MoveOn\Subscription\Models\GatewayAssociatedCustomer;
use MoveOn\Subscription\Models\PaymentGateway;
use MoveOn\Subscription\Models\Product;
use MoveOn\Subscription\Requests\CustomerStoreDTORequest;
use MoveOn\Subscription\Requests\ProductStoreDTORequest;
use MoveOn\Subscription\Requests\ProductUpdateDTORequest;

interface ServiceContractCustomer
{
    public function listCustomer(Request $request);

    public function createCustomer(PaymentGateway $gateway, CustomerStoreDTORequest $request): ?GatewayAssociatedCustomer;

    public function activateCustomer(GatewayAssociatedCustomer $customer): bool;

    public function deactivateCustomer(GatewayAssociatedCustomer $customer): bool;

}