<?php

namespace MoveOn\Subscription\Contracts;

use Illuminate\Http\Request;
use MoveOn\Subscription\Models\PaymentGateway;
use MoveOn\Subscription\Models\Product;
use MoveOn\Subscription\Requests\ProductStoreDTORequest;
use MoveOn\Subscription\Requests\ProductUpdateDTORequest;

interface ServiceContractProduct
{
    public function listProduct(Request $request);

    public function createProduct(PaymentGateway $gateway, ProductStoreDTORequest $request): Product;

    public function updateProduct(Product $product, ProductUpdateDTORequest $request): Product;
}