<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use MoveOn\Common\Traits\Filterable;
use Zoha\Metable;

class DiscountUsageHistory extends Model
{
    use HasFactory;
    use Metable;
    use Filterable;
    use SoftDeletes;

    protected $metaTable;
    protected $table;

    protected $guarded = ['id'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->table = config("subscription.subscription_table_prefix") . "_discount_usage_histories";
    }

    public function owner()
    {
        return $this->morphTo('owner');
    }

    public function discount()
    {
        return $this->belongsTo(Discount::class);
    }

    public function subscription()
    {
        return $this->belongsTo(Subscription::class, 'subscription_id');
    }
}
